using System;
using System.Text;
using System.Xml.Serialization;

namespace com.swvoyages.reservation {

	///
	/// <summary>La classe <code>HotelAvailability</code> gre les
	/// donnes d'une disponibilit de la centrale de rservation 
	/// htelire, partenaire de la socit SW-Voyages.</summary>
	///
	[SoapTypeAttribute("HotelAvailability", 
		 "http://www.sw-hotellerie-xml.org:8080/reservation_sw-hotellerie-xml/schemas/ReservationService-schema")]
	public class HotelAvailability {
		
		private static Random idGenerator = new Random();

		private int Id = 0;

		private String HotelRentalCompany = "";
		private String HotelName = "";
		private String HotelLocation = "";
		private float LowerPrice = 0;
		private float HigherPrice = 0;

		private int RemoteId = 0;

		///
		/// <summary>Le constructeur de disponibilit de la centrale
		/// de rservation htelire.</summary>
		///
		public HotelAvailability() {
			this.Id = id;
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit
		/// locale.</summary>
		///
		public int id {
			get {
				lock(this) {
					if (Id == 0) {
						Id = idGenerator.Next();
					}
					return Id;
				}
			}
			set {
			}
		}

		///
		/// <summary>Accesseurs du nom de la chaine de location 
		/// htelire.</summary>
		///
		public String hotelRentalCompany {
			get {
				return HotelRentalCompany;
			}
			set {
				this.HotelRentalCompany = value;
			}
		}

		///
		/// <summary>Accesseurs du nom de l'htel.</summary>
		///
		public String hotelName {
			get {
				return HotelName;
			}
			set {
				this.HotelName = value;
			}
		}

		///
		/// <summary>Accesseurs de la localisation de l'htel.
		/// </summary>
		///
		public String hotelLocation {
			get {
				return HotelLocation;
			}
			set {
				this.HotelLocation = value;
			}
		}

		///
		/// <summary>Accesseurs du prix de minimum de rservation.
		/// </summary>
		///
		public float lowerPrice {
			get {
				return LowerPrice;
			}
			set {
				this.LowerPrice = value;
			}
		}

		///
		/// <summary>Accesseurs du prix de maximum de rservation.
		/// </summary>
		///
		public float higherPrice {
			get {
				return HigherPrice;
			}
			set {
				this.HigherPrice = value;
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la disponibilit
		/// du partenaire.</summary>
		///
		public int remoteId {
			get {
				return RemoteId;
			}
			set {
				this.RemoteId = value;
			}
		}

		///
		/// <summary>Renvoie une reprsentation textuelle de la
		/// disponibilit du partenaire.</summary> 
		///
		/// <returns>une reprsentation textuelle de la disponibilit.
		/// </returns>
		///
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.Append("\r");
			sb.Append(GetType().FullName);
			sb.Append("@");
			sb.Append(System.Convert.ToString(GetHashCode(), 16));
			return sb.ToString();
		}
	}
}